package ru.yandex.partner.core.entity.block.type.internalrtbopts;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithInternalRtbOpts;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.utils.TypeSupportUtils;

@Component
@ParametersAreNonnullByDefault
public class BlockWithInternalRtbOptsRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithInternalRtbOpts> {

    private final JooqMapper<BlockWithInternalRtbOpts> jooqMapper;

    @Autowired
    public BlockWithInternalRtbOptsRepositoryTypeSupport(
            DSLContext dslContext,
            List<BlockRepositoryTypeSupportWithMapper<? super BlockWithInternalRtbOpts>> blockRepositoryTypeSupports) {
        super(dslContext);
        this.jooqMapper = TypeSupportUtils.buildJooqMapper(blockRepositoryTypeSupports, Set.of(BaseBlock.class));

    }

    @Override
    public JooqMapper<BlockWithInternalRtbOpts> getJooqMapper() {
        return jooqMapper;
    }

    @Override
    public Class<BlockWithInternalRtbOpts> getTypeClass() {
        return BlockWithInternalRtbOpts.class;
    }
}
