package ru.yandex.partner.core.entity.block.type.isbidding;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.block.model.BlockWithStrategyAndIsBidding;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupport;
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportWithoutMapper;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;

import static ru.yandex.partner.core.entity.block.model.prop.BlockWithStrategyMincpmPropHolder.MINCPM;
import static ru.yandex.partner.core.entity.block.model.prop.BlockWithStrategyStrategyTypePropHolder.STRATEGY_TYPE;
import static ru.yandex.partner.core.entity.block.model.prop.MobileRtbBlockIsBiddingPropHolder.IS_BIDDING;

@Component
@ParametersAreNonnullByDefault
public class BlockWithIsBiddingAndStrategyRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupport<BlockWithStrategyAndIsBidding>
        implements BlockRepositoryTypeSupportWithoutMapper<BlockWithStrategyAndIsBidding>,
        CoreModelProvider<BlockWithStrategyAndIsBidding> {

    public static final CoreModel<BlockWithStrategyAndIsBidding> MODEL =
            CoreModel.forClass(BlockWithStrategyAndIsBidding.class)
                    .property(BlockWithStrategyAndIsBidding.STRATEGY_TYPE)
                    .property(BlockWithStrategyAndIsBidding.IS_BIDDING)
                    .property(BlockWithStrategyAndIsBidding.MINCPM)
                    .build();

    public BlockWithIsBiddingAndStrategyRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
    }

    @Override
    public Set<ModelProperty<? super BlockWithStrategyAndIsBidding, ?>> getAffectedModelProperties() {
        return Set.of(IS_BIDDING, STRATEGY_TYPE, MINCPM);
    }


    @Override
    public Class<BlockWithStrategyAndIsBidding> getTypeClass() {
        return BlockWithStrategyAndIsBidding.class;
    }

    @Override
    public CoreModel<BlockWithStrategyAndIsBidding> getCoreModel() {
        return MODEL;
    }
}
