package ru.yandex.partner.core.entity.block.type.isbidding;

import NPartner.Page;
import com.fasterxml.jackson.databind.node.IntNode;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithIsBidding;
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.entity.custombkoptions.CustomBkOptionsService;
import ru.yandex.partner.core.multitype.repository.EmptyTypeSupportModifyStrategy;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;

import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonBooleanToLong;
import static ru.yandex.partner.core.entity.block.model.prop.MobileRtbBlockIsBiddingPropHolder.IS_BIDDING;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
public class BlockWithIsBiddingRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithIsBidding>
        implements  CoreModelProvider<BlockWithIsBidding>, BlockBkFiller<BlockWithIsBidding> {
    private static final CoreModel<BlockWithIsBidding> CORE_MODEL =
            CoreModel.forClass(BlockWithIsBidding.class)
                    .property(ModelPropertyDefault.<BlockWithIsBidding, Boolean>forProperty(IS_BIDDING)
                            .withDefaultValue(false))
                    .build();

    private final JooqMapper<BlockWithIsBidding> jooqMapper;
    private final CustomBkOptionsService customBkOptionsService;

    public BlockWithIsBiddingRepositoryTypeSupport(DSLContext dslContext,
                                                   CustomBkOptionsService customBkOptionsService) {
        super(dslContext, new EmptyTypeSupportModifyStrategy<>());
        jooqMapper = createBlockMapper();
        this.customBkOptionsService = customBkOptionsService;

    }

    private static JooqMapper<BlockWithIsBidding> createBlockMapper() {
        return JooqMapperBuilder.<BlockWithIsBidding>builder()
                .map(jsonBooleanToLong(IS_BIDDING, CONTEXT_ON_SITE_RTB.OPTS,
                                "is_bidding")
                    )
                .build();
    }

    @Override
    public JooqMapper<BlockWithIsBidding> getJooqMapper() {
        return jooqMapper;
    }

    @Override
    public Class<BlockWithIsBidding> getTypeClass() {
        return BlockWithIsBidding.class;
    }

    @Override
    public CoreModel<BlockWithIsBidding> getCoreModel() {
        return CORE_MODEL;
    }

    @Override
    public void fillBkData(@NotNull BlockWithIsBidding model,
                           @NotNull Page.TPartnerPage.TBlock.Builder bkData, BlockBkDictContainer container) {
            String customBlockData = customBkOptionsService.set(
                    bkData.getCustomBlockData(),
                    "IsBidding",
                    IntNode.valueOf(Boolean.TRUE.equals(model.getIsBidding()) ? 1 : 0)
            );
            bkData.setCustomBlockData(customBlockData);
    }

}
