package ru.yandex.partner.core.entity.block.type.isbidding;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithStrategyAndIsBidding;
import ru.yandex.partner.core.entity.block.service.type.add.AbstractBlockAddOperationTypeSupport;

import static ru.yandex.partner.core.CoreConstants.Strategies.MAX_REVENUE_STRATEGY_ID;

@Component
@ParametersAreNonnullByDefault
public class BlockWithStrategyAndIsBiddingAddOperationTypeSupport
        extends AbstractBlockAddOperationTypeSupport<BlockWithStrategyAndIsBidding> {

    @Override
    public Class<BlockWithStrategyAndIsBidding> getTypeClass() {
        return BlockWithStrategyAndIsBidding.class;
    }

    @Override
    public void onPreValidated(BlockContainer addContainer, List<BlockWithStrategyAndIsBidding> models) {
        for (BlockWithStrategyAndIsBidding model : models) {
            if (model.getIsBidding() != null && model.getIsBidding()) {
                model.setStrategyType(MAX_REVENUE_STRATEGY_ID);
                model.setMincpm(null);
            }
        }
    }
}
