package ru.yandex.partner.core.entity.block.type.isbidding;

import java.util.List;
import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithStrategyAndIsBidding;
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportFacade;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;

import static ru.yandex.partner.core.CoreConstants.Strategies.MAX_REVENUE_STRATEGY_ID;

@Component
public class BlockWithStrategyAndIsBiddingUpdateOperationTypeSupport
        extends AbstractBlockUpdateOperationTypeSupport<BlockWithStrategyAndIsBidding> {
    public BlockWithStrategyAndIsBiddingUpdateOperationTypeSupport(BlockRepositoryTypeSupportFacade repositoryFacade) {
        super(repositoryFacade);
    }

    @Override
    public Class<BlockWithStrategyAndIsBidding> getTypeClass() {
        return BlockWithStrategyAndIsBidding.class;
    }

    @Override
    public void onChangesApplied(BlockContainer updateContainer,
                                 List<AppliedChanges<BlockWithStrategyAndIsBidding>> appliedChanges) {
        for (AppliedChanges<BlockWithStrategyAndIsBidding> changes : appliedChanges) {
            if (!changes.changed(BlockWithStrategyAndIsBidding.IS_BIDDING)) {
                continue;
            }
            if (Boolean.TRUE.equals(changes.getNewValue(BlockWithStrategyAndIsBidding.IS_BIDDING))) {
                changes.modify(BlockWithStrategyAndIsBidding.STRATEGY_TYPE, MAX_REVENUE_STRATEGY_ID);
                changes.modify(BlockWithStrategyAndIsBidding.MINCPM, null);
            }
        }
    }

    @Override
    public Set<ModelProperty<? super BlockWithStrategyAndIsBidding, ?>> needBsResyncProps() {
        return Set.of(BlockWithStrategyAndIsBidding.IS_BIDDING);
    }
}
