package ru.yandex.partner.core.entity.block.type.iscustomformatdirect;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithIsCustomFormatDirect;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.multitype.repository.EmptyTypeSupportModifyStrategy;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;

import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonBooleanToLong;
import static ru.yandex.partner.core.entity.block.model.prop.BlockWithIsCustomFormatDirectIsCustomFormatDirectPropHolder.IS_CUSTOM_FORMAT_DIRECT;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
public class BlockWithIsCustomFormatDirectRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithIsCustomFormatDirect>
        implements  CoreModelProvider<BlockWithIsCustomFormatDirect> {
    private static final CoreModel<BlockWithIsCustomFormatDirect> CORE_MODEL =
            CoreModel.forClass(BlockWithIsCustomFormatDirect.class)
                    .property(ModelPropertyDefault.<BlockWithIsCustomFormatDirect, Boolean>
                                    forProperty(IS_CUSTOM_FORMAT_DIRECT)
                            .withDefaultValueOnAdd(false))
                    .build();

    private final JooqMapper<BlockWithIsCustomFormatDirect> jooqMapper;

    public BlockWithIsCustomFormatDirectRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext, new EmptyTypeSupportModifyStrategy<>());
        jooqMapper = createBlockMapper();
    }

    private static JooqMapper<BlockWithIsCustomFormatDirect> createBlockMapper() {
        return JooqMapperBuilder.<BlockWithIsCustomFormatDirect>builder()
                .map(jsonBooleanToLong(IS_CUSTOM_FORMAT_DIRECT, CONTEXT_ON_SITE_RTB.OPTS,
                                "is_custom_format_direct")
                    )
                .build();
    }

    @Override
    public JooqMapper<BlockWithIsCustomFormatDirect> getJooqMapper() {
        return jooqMapper;
    }

    @Override
    public Class<BlockWithIsCustomFormatDirect> getTypeClass() {
        return BlockWithIsCustomFormatDirect.class;
    }

    @Override
    public CoreModel<BlockWithIsCustomFormatDirect> getCoreModel() {
        return CORE_MODEL;
    }
}
