package ru.yandex.partner.core.entity.block.type.isexternalmediation;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithIsExternalMediation;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.multitype.repository.EmptyTypeSupportModifyStrategy;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;

import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonBooleanToLong;
import static ru.yandex.partner.core.entity.block.model.prop.MobileRtbBlockIsExternalMediationPropHolder.IS_EXTERNAL_MEDIATION;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
public class BlockWithIsExternalMediationRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithIsExternalMediation>
        implements  CoreModelProvider<BlockWithIsExternalMediation> {
    private static final CoreModel<BlockWithIsExternalMediation> CORE_MODEL =
            CoreModel.forClass(BlockWithIsExternalMediation.class)
                    .property(ModelPropertyDefault.<BlockWithIsExternalMediation, Boolean>
                                    forProperty(IS_EXTERNAL_MEDIATION)
                            .withDefaultValueOnAdd(false))
                    .build();

    private final JooqMapper<BlockWithIsExternalMediation> jooqMapper;

    public BlockWithIsExternalMediationRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext, new EmptyTypeSupportModifyStrategy<>());
        jooqMapper = createBlockMapper();
    }

    private static JooqMapper<BlockWithIsExternalMediation> createBlockMapper() {
        return JooqMapperBuilder.<BlockWithIsExternalMediation>builder()
                .map(jsonBooleanToLong(IS_EXTERNAL_MEDIATION, CONTEXT_ON_SITE_RTB.OPTS,
                                "is_external_mediation")
                    )
                .build();
    }

    @Override
    public JooqMapper<BlockWithIsExternalMediation> getJooqMapper() {
        return jooqMapper;
    }

    @Override
    public Class<BlockWithIsExternalMediation> getTypeClass() {
        return BlockWithIsExternalMediation.class;
    }

    @Override
    public CoreModel<BlockWithIsExternalMediation> getCoreModel() {
        return CORE_MODEL;
    }

}
