package ru.yandex.partner.core.entity.block.type.ismobilemediation;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithIsMobileMediation;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.multitype.repository.EmptyTypeSupportModifyStrategy;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;

import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonBooleanToLong;
import static ru.yandex.partner.core.entity.block.model.prop.MobileRtbBlockIsMobileMediationPropHolder.IS_MOBILE_MEDIATION;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
public class BlockWithIsMobileMediationRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithIsMobileMediation>
        implements  CoreModelProvider<BlockWithIsMobileMediation> {
    private static final CoreModel<BlockWithIsMobileMediation> CORE_MODEL =
            CoreModel.forClass(BlockWithIsMobileMediation.class)
                    .property(ModelPropertyDefault.<BlockWithIsMobileMediation, Boolean>forProperty(IS_MOBILE_MEDIATION)
                            .withDefaultValueOnAdd(false))
                    .build();

    private final JooqMapper<BlockWithIsMobileMediation> jooqMapper;

    public BlockWithIsMobileMediationRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext, new EmptyTypeSupportModifyStrategy<>());
        jooqMapper = createBlockMapper();
    }

    private static JooqMapper<BlockWithIsMobileMediation> createBlockMapper() {
        return JooqMapperBuilder.<BlockWithIsMobileMediation>builder()
                .map(jsonBooleanToLong(IS_MOBILE_MEDIATION, CONTEXT_ON_SITE_RTB.OPTS,
                                "is_mobile_mediation")
                    )
                .build();
    }

    @Override
    public JooqMapper<BlockWithIsMobileMediation> getJooqMapper() {
        return jooqMapper;
    }

    @Override
    public Class<BlockWithIsMobileMediation> getTypeClass() {
        return BlockWithIsMobileMediation.class;
    }

    @Override
    public CoreModel<BlockWithIsMobileMediation> getCoreModel() {
        return CORE_MODEL;
    }
}
