package ru.yandex.partner.core.entity.block.type.mobileappandplaceid;

import java.util.Optional;

import NPartner.Page;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.adfox.model.AdfoxInfo;
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithMobileAppSettingsAndPlaceId;
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller;
import ru.yandex.partner.core.entity.page.model.MobileAppSettings;
import ru.yandex.partner.core.entity.user.model.User;

@Component
public class BlockWithMobileAppSettingsAndPlaceIdBkFiller
        implements BlockBkFiller<BlockWithMobileAppSettingsAndPlaceId> {
    @Override
    public void fillBkData(@NotNull BlockWithMobileAppSettingsAndPlaceId model,
                           @NotNull Page.TPartnerPage.TBlock.Builder bkData, BlockBkDictContainer container) {

        AdfoxInfo adfoxInfo = Optional.ofNullable(model.getCampaign())
                .map(MobileAppSettings::getOwner)
                .map(User::getAdfoxInfos)
                .map(list -> list.get(0))
                .orElse(null);

        if (adfoxInfo != null && Boolean.TRUE.equals(model.getIsMobileMediation())) {
            Optional.ofNullable(model.getPlaceId()).map(Long::intValue).ifPresent(bkData::setAdfoxPlaceID);
            Optional.ofNullable(adfoxInfo.getAdfoxId()).map(Long::intValue).ifPresent(bkData::setAdfoxOwnerID);
        }

    }

    @Override
    public Class<BlockWithMobileAppSettingsAndPlaceId> getTypeClass() {
        return BlockWithMobileAppSettingsAndPlaceId.class;
    }
}
