package ru.yandex.partner.core.entity.block.type.mobileappmode;

import javax.annotation.ParametersAreNonnullByDefault;

import NPartner.Page.TPartnerPage;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders;
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithMobileAppMode;
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.multitype.repository.EmptyTypeSupportModifyStrategy;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;
import ru.yandex.partner.dbschema.partner.tables.ContextOnSiteRtb;

import static ru.yandex.partner.core.entity.block.model.prop.BlockWithMobileAppModeMobileAppModePropHolder.MOBILE_APP_MODE;

@Component
@ParametersAreNonnullByDefault
public class BlockWithMobileAppModeRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithMobileAppMode>
        implements BlockBkFiller<BlockWithMobileAppMode>, CoreModelProvider<BlockWithMobileAppMode> {

    public static final CoreModel<BlockWithMobileAppMode> MODEL = CoreModel.forClass(BlockWithMobileAppMode.class)
            .property(ModelPropertyDefault.<BlockWithMobileAppMode, Integer>forProperty(MOBILE_APP_MODE)
                    .withDefaultValueOnAdd(0))
            .build();

    private final JooqMapper<BlockWithMobileAppMode> mapper;

    public BlockWithMobileAppModeRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext, new EmptyTypeSupportModifyStrategy<>());
        this.mapper = createCommonJooqMapper();
    }

    private static JooqMapper<BlockWithMobileAppMode> createCommonJooqMapper() {
        return JooqMapperBuilder.<BlockWithMobileAppMode>builder()
                .map(JsonReaderWriterBuilders.jsonInteger(
                        MOBILE_APP_MODE,
                        ContextOnSiteRtb.CONTEXT_ON_SITE_RTB.OPTS,
                        "mobile_app_mode"
                ))
                .build();
    }

    @Override
    public JooqMapper<BlockWithMobileAppMode> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<BlockWithMobileAppMode> getTypeClass() {
        return BlockWithMobileAppMode.class;
    }

    @Override
    public void fillBkData(@NotNull BlockWithMobileAppMode model,
                           @NotNull TPartnerPage.TBlock.Builder bkData,
                           BlockBkDictContainer container) {

        if (model.getMobileAppMode() == 1) {
            bkData.getPageImpOptionsBuilder().addEnable("no-mobile-app");
        } else {
            bkData.getPageImpOptionsBuilder().addDisable("no-mobile-app");
        }

        if (model.getMobileAppMode() == 2) {
            bkData.getPageImpOptionsBuilder().addEnable("only-mobile-app");
        } else {
            bkData.getPageImpOptionsBuilder().addDisable("only-mobile-app");
        }

    }

    @Override
    public CoreModel<BlockWithMobileAppMode> getCoreModel() {
        return MODEL;
    }

}
