package ru.yandex.partner.core.entity.block.type.mobileappmode;

import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.block.BlockType;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithMobileAppMode;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;

@Component
public class BlockWithMobileAppModeUpdateOperationTypeSupport
        extends AbstractBlockUpdateOperationTypeSupport<BlockWithMobileAppMode> {


    public BlockWithMobileAppModeUpdateOperationTypeSupport(PartnerRepositoryTypeSupportFacade<BaseBlock, BlockType,
            BlockContainer, BlockContainer> repositoryFacade) {
        super(repositoryFacade);
    }

    @Override
    public Class<BlockWithMobileAppMode> getTypeClass() {
        return BlockWithMobileAppMode.class;
    }

    @Override
    public Set<ModelProperty<? super BlockWithMobileAppMode, ?>> needBsResyncProps() {
        return Set.of(BlockWithMobileAppMode.MOBILE_APP_MODE);
    }

}
