package ru.yandex.partner.core.entity.block.type.mobileappmode;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithMobileAppMode;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;


@Component
public class BlockWithMobileAppModeValidationTypeSupport
        extends AbstractBlockValidationTypeSupport<BlockWithMobileAppMode> {

    private final Validator<BlockWithMobileAppMode, Defect> validator;

    @Autowired
    public BlockWithMobileAppModeValidationTypeSupport(BlockWithMobileAppModeValidatorProvider validatorProvider) {
        this.validator = validatorProvider.validator();
    }

    @Override
    public Class<BlockWithMobileAppMode> getTypeClass() {
        return BlockWithMobileAppMode.class;
    }


    @Override
    public ValidationResult<List<BlockWithMobileAppMode>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<BlockWithMobileAppMode>, Defect> vr) {

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }
}
