package ru.yandex.partner.core.entity.block.type.mobileappmode;

import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.core.entity.block.model.BlockWithMobileAppMode;

import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;

@Component
public class BlockWithMobileAppModeValidatorProvider {

    public <M extends BlockWithMobileAppMode> Validator<M, Defect> validator() {
        return block -> {
            var vb = ModelItemValidationBuilder.of(block);
            var availableValues = Set.of(
                    CoreConstants.MobileAppModes.ANYTHING,
                    CoreConstants.MobileAppModes.ONLY_MOBILE_APP_ADD,
                    CoreConstants.MobileAppModes.WITHOUT_MOBILE_APP_ADD);

            vb.item(BlockWithMobileAppMode.MOBILE_APP_MODE)
                    .check(inSet(availableValues));

            return vb.getResult();
        };
    }

}
