package ru.yandex.partner.core.entity.block.type.mobilereward;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.block.MobileBlockType;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithMobileRewardAndBlockType;
import ru.yandex.partner.core.entity.block.service.type.add.AbstractBlockAddOperationTypeSupport;


@Component
@ParametersAreNonnullByDefault
public class BlockWithMobileRewardAndBlockTypeAddOperationTypeSupport
        extends AbstractBlockAddOperationTypeSupport<BlockWithMobileRewardAndBlockType> {

    @Override
    public Class<BlockWithMobileRewardAndBlockType> getTypeClass() {
        return BlockWithMobileRewardAndBlockType.class;
    }

    @Override
    public void onPreValidated(BlockContainer addContainer, List<BlockWithMobileRewardAndBlockType> models) {
        for (BlockWithMobileRewardAndBlockType model : models) {
            if (!MobileBlockType.REWARDED.hasType(model)) {
                model.setCurrencyType(null);
                model.setCurrencyValue(null);
                model.setCallback(null);
                model.setSign(null);
            }
        }
    }
}
