package ru.yandex.partner.core.entity.block.type.mobilereward;

import java.util.Set;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.block.MobileBlockType;
import ru.yandex.partner.core.entity.block.model.BlockWithMobileRewardAndBlockType;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupport;
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportWithoutMapper;
import ru.yandex.partner.core.holder.ModelPropertiesHolder;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;

import static ru.yandex.partner.core.entity.block.model.prop.MobileRtbBlockCallbackPropHolder.CALLBACK;
import static ru.yandex.partner.core.entity.block.model.prop.MobileRtbBlockCurrencyTypePropHolder.CURRENCY_TYPE;
import static ru.yandex.partner.core.entity.block.model.prop.MobileRtbBlockCurrencyValuePropHolder.CURRENCY_VALUE;
import static ru.yandex.partner.core.entity.block.model.prop.MobileRtbBlockSignPropHolder.SIGN;
import static ru.yandex.partner.core.holder.ModelPropertiesHolder.fromModelProperties;
import static ru.yandex.partner.core.props.ChangePredicate.havingPropertyValue;

@Component
public class BlockWithMobileRewardAndBlockTypeRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupport<BlockWithMobileRewardAndBlockType>
        implements BlockRepositoryTypeSupportWithoutMapper<BlockWithMobileRewardAndBlockType>,
        CoreModelProvider<BlockWithMobileRewardAndBlockType> {
    private static final CoreModel<BlockWithMobileRewardAndBlockType> CORE_MODEL =
            CoreModel.forClass(BlockWithMobileRewardAndBlockType.class)
                    .dependentPropertiesWhen(havingPropertyValue(
                            BlockWithMobileRewardAndBlockType.BLOCK_TYPE, MobileBlockType.REWARDED.getLiteral()),
                            configuration -> {
                                configuration.property(CURRENCY_TYPE);
                                configuration.property(CURRENCY_VALUE);
                                configuration.property(CALLBACK);
                                configuration.property(SIGN);
                            })
                    .build();


    public BlockWithMobileRewardAndBlockTypeRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
    }

    @Override
    public ModelPropertiesHolder getEditableModelProperties(BlockWithMobileRewardAndBlockType model) {
        ModelPropertiesHolder holder = new ModelPropertiesHolder();
        if (MobileBlockType.REWARDED.getLiteral().equals(model.getBlockType())) {
            return fromModelProperties(
                    Set.of(BlockWithMobileRewardAndBlockType.CURRENCY_TYPE,
                            BlockWithMobileRewardAndBlockType.CURRENCY_VALUE,
                            BlockWithMobileRewardAndBlockType.CALLBACK,
                            BlockWithMobileRewardAndBlockType.SIGN)
            );
        }

        return holder;
    }


    @Override
    public Set<ModelProperty<? super BlockWithMobileRewardAndBlockType, ?>> getAffectedModelProperties() {
        return Set.of(
                BlockWithMobileRewardAndBlockType.BLOCK_TYPE,
                CURRENCY_TYPE,
                CURRENCY_VALUE,
                CALLBACK,
                SIGN
        );
    }

    @Override
    public Class<BlockWithMobileRewardAndBlockType> getTypeClass() {
        return BlockWithMobileRewardAndBlockType.class;
    }

    @Override
    public CoreModel<BlockWithMobileRewardAndBlockType> getCoreModel() {
        return CORE_MODEL;
    }

}

