package ru.yandex.partner.core.entity.block.type.mobilereward;

import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.block.model.BlockWithMobileRewardAndBlockType;
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportFacade;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;

@Component
public class BlockWithMobileRewardAndBlockTypeUpdateOperationTypeSupport
        extends AbstractBlockUpdateOperationTypeSupport<BlockWithMobileRewardAndBlockType> {
    public BlockWithMobileRewardAndBlockTypeUpdateOperationTypeSupport(
            BlockRepositoryTypeSupportFacade repositoryFacade) {
        super(repositoryFacade);
    }

    @Override
    public Class<BlockWithMobileRewardAndBlockType> getTypeClass() {
        return BlockWithMobileRewardAndBlockType.class;
    }


    @Override
    public Set<ModelProperty<? super BlockWithMobileRewardAndBlockType, ?>> needBsResyncProps() {
        return Set.of(BlockWithMobileRewardAndBlockType.CALLBACK,
                        BlockWithMobileRewardAndBlockType.CURRENCY_TYPE,
                        BlockWithMobileRewardAndBlockType.CURRENCY_VALUE,
                        BlockWithMobileRewardAndBlockType.SIGN);
    }
}
