package ru.yandex.partner.core.entity.block.type.mobilereward;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithMobileReward;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.multitype.repository.EmptyTypeSupportModifyStrategy;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;

import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonInteger;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonString;
import static ru.yandex.partner.core.entity.block.model.prop.MobileRtbBlockCallbackPropHolder.CALLBACK;
import static ru.yandex.partner.core.entity.block.model.prop.MobileRtbBlockCurrencyTypePropHolder.CURRENCY_TYPE;
import static ru.yandex.partner.core.entity.block.model.prop.MobileRtbBlockCurrencyValuePropHolder.CURRENCY_VALUE;
import static ru.yandex.partner.core.entity.block.model.prop.MobileRtbBlockSignPropHolder.SIGN;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
public class BlockWithMobileRewardRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithMobileReward>
        implements  CoreModelProvider<BlockWithMobileReward> {
    private static final CoreModel<BlockWithMobileReward> CORE_MODEL =
            CoreModel.forClass(BlockWithMobileReward.class)
                    .property(ModelPropertyDefault.<BlockWithMobileReward, String>
                            forProperty(CURRENCY_TYPE))
                    .property(ModelPropertyDefault.<BlockWithMobileReward, Integer>
                            forProperty(CURRENCY_VALUE))
                    .property(ModelPropertyDefault.<BlockWithMobileReward, String>
                            forProperty(CALLBACK))
                    .property(ModelPropertyDefault.<BlockWithMobileReward, String>
                            forProperty(SIGN))
                    .build();

    private final JooqMapper<BlockWithMobileReward> jooqMapper;

    public BlockWithMobileRewardRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext, new EmptyTypeSupportModifyStrategy<>());
        jooqMapper = createBlockMapper();
    }

    private static JooqMapper<BlockWithMobileReward> createBlockMapper() {
        return JooqMapperBuilder.<BlockWithMobileReward>builder()
                .map(jsonString(CURRENCY_TYPE, CONTEXT_ON_SITE_RTB.OPTS, "currency_type"))
                .map(jsonInteger(CURRENCY_VALUE, CONTEXT_ON_SITE_RTB.OPTS, "currency_value"))
                .map(jsonString(CALLBACK, CONTEXT_ON_SITE_RTB.OPTS, "callback"))
                .map(jsonString(SIGN, CONTEXT_ON_SITE_RTB.OPTS, "sign"))
                .build();
    }

    @Override
    public JooqMapper<BlockWithMobileReward> getJooqMapper() {
        return jooqMapper;
    }

    @Override
    public Class<BlockWithMobileReward> getTypeClass() {
        return BlockWithMobileReward.class;
    }

    @Override
    public CoreModel<BlockWithMobileReward> getCoreModel() {
        return CORE_MODEL;
    }
}

