package ru.yandex.partner.core.entity.block.type.mobilereward;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithMobileRewardAndBlockType;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;


@Component
public class BlockWithMobileRewardValidationTypeSupport
        extends AbstractBlockValidationTypeSupport<BlockWithMobileRewardAndBlockType> {

    private final Validator<BlockWithMobileRewardAndBlockType, Defect> validator;

    @Autowired
    public BlockWithMobileRewardValidationTypeSupport(MobileRewardValidatorProvider validatorProvider) {
        this.validator = validatorProvider.validator();
    }

    @Override
    public Class<BlockWithMobileRewardAndBlockType> getTypeClass() {
        return BlockWithMobileRewardAndBlockType.class;
    }


    @Override
    public ValidationResult<List<BlockWithMobileRewardAndBlockType>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<BlockWithMobileRewardAndBlockType>, Defect> vr) {

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }
}
