package ru.yandex.partner.core.entity.block.type.mobilereward;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.constraint.StringConstraints;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.block.MobileBlockType;
import ru.yandex.partner.core.entity.block.model.BlockWithMobileRewardAndBlockType;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@Component
public class MobileRewardValidatorProvider {


    public <M extends BlockWithMobileRewardAndBlockType> Validator<M, Defect> validator() {
        return block -> {
            var vb = ModelItemValidationBuilder.of(block);
            if (MobileBlockType.REWARDED.hasType(block)) {
                vb.item(BlockWithMobileRewardAndBlockType.CURRENCY_TYPE)
                        .check(notNull())
                        .check(StringConstraints.maxStringLength(64))
                        .check(StringConstraints.minStringLength(1));
                vb.item(BlockWithMobileRewardAndBlockType.CALLBACK)
                        .check(StringConstraints.maxStringLength(255), When.notNull())
                        .check(StringConstraints.minStringLength(1), When.notNull());
                vb.item(BlockWithMobileRewardAndBlockType.SIGN)
                        .check(StringConstraints.maxStringLength(64), When.notNull())
                        .check(StringConstraints.minStringLength(1), When.notNull());
            }
            return vb.getResult();
        };
    }
}
