package ru.yandex.partner.core.entity.block.type.mobilertbopts;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithInternalMobileRtbOpts;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.utils.TypeSupportUtils;

@Component
@ParametersAreNonnullByDefault
public class BlockWithInternalMobileRtbOptsRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithInternalMobileRtbOpts> {

    private final JooqMapper<BlockWithInternalMobileRtbOpts> jooqMapper;

    @Autowired
    public BlockWithInternalMobileRtbOptsRepositoryTypeSupport(
            DSLContext dslContext,
            List<BlockRepositoryTypeSupportWithMapper<? super BlockWithInternalMobileRtbOpts>>
                    blockRepositoryTypeSupports) {
        super(dslContext);
        this.jooqMapper = TypeSupportUtils.buildJooqMapper(blockRepositoryTypeSupports, Set.of(BaseBlock.class));

    }

    @Override
    public JooqMapper<BlockWithInternalMobileRtbOpts> getJooqMapper() {
        return jooqMapper;
    }

    @Override
    public Class<BlockWithInternalMobileRtbOpts> getTypeClass() {
        return BlockWithInternalMobileRtbOpts.class;
    }
}
