package ru.yandex.partner.core.entity.block.type.mobilertbopts;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithMobileRtbOpts;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.utils.TypeSupportUtils;

@Component
@ParametersAreNonnullByDefault
public class BlockWithMobileRtbOptsRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithMobileRtbOpts> {

    private final JooqMapper<BlockWithMobileRtbOpts> jooqMapper;

    @Autowired
    public BlockWithMobileRtbOptsRepositoryTypeSupport(
            DSLContext dslContext,
            List<BlockRepositoryTypeSupportWithMapper<? super BlockWithMobileRtbOpts>> blockRepositoryTypeSupports) {
        super(dslContext);
        this.jooqMapper = TypeSupportUtils.buildJooqMapper(blockRepositoryTypeSupports, Set.of(BaseBlock.class));

    }

    @Override
    public JooqMapper<BlockWithMobileRtbOpts> getJooqMapper() {
        return jooqMapper;
    }

    @Override
    public Class<BlockWithMobileRtbOpts> getTypeClass() {
        return BlockWithMobileRtbOpts.class;
    }
}
