package ru.yandex.partner.core.entity.block.type.multistate;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithMultistate;
import ru.yandex.partner.core.entity.block.service.type.add.AbstractBlockAddOperationTypeSupport;
import ru.yandex.partner.core.multistate.block.BlockMultistate;

@Component
public class BlockWithMultistateAddOperationTypeSupport extends
        AbstractBlockAddOperationTypeSupport<BlockWithMultistate> {
    @Override
    public void onDuplicate(BlockContainer addModelContainer, List<BlockWithMultistate> models) {
        models.forEach(model -> model.setMultistate(new BlockMultistate()));
    }

    @Override
    public Class<BlockWithMultistate> getTypeClass() {
        return BlockWithMultistate.class;
    }
}
