package ru.yandex.partner.core.entity.block.type.multistate;

import java.util.Collection;
import java.util.HashSet;

import javax.annotation.ParametersAreNonnullByDefault;

import NPartner.Page.TPartnerPage;
import com.google.common.collect.Sets;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithMultistate;
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.holder.ModelPropertiesHolder;
import ru.yandex.partner.core.multistate.AbstractMultistate;
import ru.yandex.partner.core.multistate.block.BlockMultistate;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.partner.core.entity.block.type.base.BaseBlockConstants.EDIT_FORBIDDEN_MODEL_PROPERTIES;
import static ru.yandex.partner.core.holder.ModelPropertiesHolder.fromModelProperties;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
@ParametersAreNonnullByDefault
public class BlockWithMultistateRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithMultistate>
        implements CoreModelProvider<BlockWithMultistate>, BlockBkFiller<BlockWithMultistate> {
    private static final CoreModel<BlockWithMultistate> DEFAULT_VALUES =
            CoreModel.forClass(BlockWithMultistate.class)
                    .property(
                            ModelPropertyDefault.<BlockWithMultistate, BlockMultistate>forProperty(
                                            BlockWithMultistate.MULTISTATE
                                    )
                                    .mandatoryOnAdd(BlockMultistate::new)
                    )
                    .build();
    private final JooqMapper<BlockWithMultistate> mapper;
    private final ModelPropertiesHolder editableProperties;


    @Autowired
    protected BlockWithMultistateRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
        this.mapper = createCommonBlockMapper();
        this.editableProperties = fromModelProperties(
                new HashSet<>(
                        Sets.difference(mapper.getWritableModelProperties(), EDIT_FORBIDDEN_MODEL_PROPERTIES)
                )
        );
    }

    private static JooqMapper<BlockWithMultistate> createCommonBlockMapper() {
        return JooqMapperBuilder.<BlockWithMultistate>builder()
                .map(convertibleProperty(BlockWithMultistate.MULTISTATE, CONTEXT_ON_SITE_RTB.MULTISTATE,
                        BlockMultistate::new, AbstractMultistate::toMultistateValue))
                .build();
    }

    @Override
    public JooqMapper<BlockWithMultistate> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<BlockWithMultistate> getTypeClass() {
        return BlockWithMultistate.class;
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<BlockWithMultistate> blocks) {
    }

    @Override
    public ModelPropertiesHolder getEditableModelProperties(BlockWithMultistate model) {
        return editableProperties;
    }

    @Override
    public CoreModel<BlockWithMultistate> getCoreModel() {
        return DEFAULT_VALUES;
    }

    @Override
    public void fillBkData(@NotNull BlockWithMultistate block,
                           @NotNull TPartnerPage.TBlock.Builder bkData,
                           @NotNull BlockBkDictContainer container) {
        bkData.setMultiState((int) block.getMultistate().toMultistateValue());
    }
}
