package ru.yandex.partner.core.entity.block.type.multistate

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.partner.core.entity.block.container.BlockContainer
import ru.yandex.partner.core.entity.block.model.BlockWithMultistate
import ru.yandex.partner.core.entity.block.service.OperationMode
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport
import ru.yandex.partner.core.multistate.block.BlockMultistate
import ru.yandex.partner.core.multistate.block.BlockStateFlag.DELETED

@Component
class BlockWithMultistateValidationTypeSupport
@Autowired
constructor(validatorProvider: BlockWithMultistateValidatorProvider) :
    AbstractBlockValidationTypeSupport<BlockWithMultistate>() {
    private val validator: Validator<BlockWithMultistate, Defect<*>>
    private val addValidator: Validator<BlockWithMultistate, Defect<*>>

    init {
        validator = validatorProvider.validator()
        addValidator = validatorProvider.addPreValidator()
    }

    override fun getTypeClass(): Class<BlockWithMultistate> {
        return BlockWithMultistate::class.java
    }

    override fun addPreValidate(
        container: BlockContainer,
        vr: ValidationResult<List<BlockWithMultistate>?, Defect<*>>?
    ): ValidationResult<List<BlockWithMultistate>, Defect<*>> {
        return ListValidationBuilder(vr).checkEachBy(addValidator, When.isTrue(container.mode.creation())).result
    }

    override fun fillContainer(container: BlockContainer, models: List<BlockWithMultistate>) {
        // В режиме крона не валидируем bk_data у архивных блоков
        if (container.mode == OperationMode.CRON) {
            container.validatingBkDataMap = models.associate { b ->
                b.id to (b.multistate ?: BlockMultistate()).hasFlag(DELETED).not()
            }
        }
    }

    override fun validate(
        container: BlockContainer,
        vr: ValidationResult<List<BlockWithMultistate>?, Defect<*>>?
    ): ValidationResult<List<BlockWithMultistate>, Defect<*>> {
        return ListValidationBuilder(vr).checkEachBy(validator).result
    }
}
