package ru.yandex.partner.core.entity.block.type.multistate;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithMultistate;
import ru.yandex.partner.core.multistate.block.BlockMultistate;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.partner.core.validation.defects.TypeDefects.invalidTypeMustBeIntegerNumber;

@Component
public class BlockWithMultistateValidatorProvider {

    public <M extends BlockWithMultistate> Validator<M, Defect> validator() {
        return block -> {
            var vb = ModelItemValidationBuilder.of(block);

            vb.item(BlockWithMultistate.MULTISTATE)
                    .check(notNull(), invalidTypeMustBeIntegerNumber());

            return vb.getResult();
        };
    }

    public Validator<BlockWithMultistate, Defect> addPreValidator() {
        return block -> {
            var vb = ModelItemValidationBuilder.of(block);

            // TODO invent MultistateMsg
            vb.item(BlockWithMultistate.MULTISTATE)
                    .check(Constraint.fromPredicate(new BlockMultistate()::equals, invalidTypeMustBeIntegerNumber()));

            return vb.getResult();
        };
    }
}

