package ru.yandex.partner.core.entity.block.type.onlyportaltrustedbanners;

import javax.annotation.ParametersAreNonnullByDefault;

import NPartner.Page.TPartnerPage;
import com.fasterxml.jackson.databind.node.LongNode;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithOnlyPortalTrustedBanners;
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.entity.custombkoptions.CustomBkOptionsService;
import ru.yandex.partner.core.multitype.repository.EmptyTypeSupportModifyStrategy;

import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonBooleanToLong;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
@ParametersAreNonnullByDefault
public class BlockWithOnlyPortalTrustedBannersRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithOnlyPortalTrustedBanners>
implements BlockBkFiller<BlockWithOnlyPortalTrustedBanners> {

    private final CustomBkOptionsService customBkOptionsService;
    private final JooqMapper<BlockWithOnlyPortalTrustedBanners> mapper;

    @Autowired
    public BlockWithOnlyPortalTrustedBannersRepositoryTypeSupport(DSLContext dslContext,
                                                                  CustomBkOptionsService customBkOptionsService) {
        super(dslContext, new EmptyTypeSupportModifyStrategy<>());
        this.customBkOptionsService = customBkOptionsService;
        this.mapper = JooqMapperBuilder.<BlockWithOnlyPortalTrustedBanners>builder()
                .map(jsonBooleanToLong(BlockWithOnlyPortalTrustedBanners.ONLY_PORTAL_TRUSTED_BANNERS,
                        CONTEXT_ON_SITE_RTB.OPTS, "only_portal_trusted_banners"))
                .build();
    }

    @Override
    public JooqMapper<BlockWithOnlyPortalTrustedBanners> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<BlockWithOnlyPortalTrustedBanners> getTypeClass() {
        return BlockWithOnlyPortalTrustedBanners.class;
    }

    @Override
    public void fillBkData(@NotNull BlockWithOnlyPortalTrustedBanners block,
                           @NotNull TPartnerPage.TBlock.Builder bkData, BlockBkDictContainer container) {
        String customBlockData = customBkOptionsService.set(bkData.getCustomBlockData(),
                "only-portal-trusted-banners",
                LongNode.valueOf(Boolean.TRUE.equals(block.getOnlyPortalTrustedBanners()) ? 1 : 0)
        );
        bkData.setCustomBlockData(customBlockData);
    }
}
