package ru.yandex.partner.core.entity.block.type.onlyportaltrustedbanners;

import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.block.BlockType;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithOnlyPortalTrustedBanners;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;

@Component
public class BlockWithOnlyPortalTrustedBannersUpdateOperationTypeSupport
        extends AbstractBlockUpdateOperationTypeSupport<BlockWithOnlyPortalTrustedBanners> {
    private static final Set<ModelProperty<? super BlockWithOnlyPortalTrustedBanners, ?>> NEED_UPDATE_IN_BK_FIELDS =
            Set.of(BlockWithOnlyPortalTrustedBanners.ONLY_PORTAL_TRUSTED_BANNERS);

    @Autowired
    public BlockWithOnlyPortalTrustedBannersUpdateOperationTypeSupport(
            PartnerRepositoryTypeSupportFacade<BaseBlock, BlockType, BlockContainer, BlockContainer> repositoryFacade) {
        super(repositoryFacade);
    }

    @Override
    public Class<BlockWithOnlyPortalTrustedBanners> getTypeClass() {
        return BlockWithOnlyPortalTrustedBanners.class;
    }

    @Override
    public Set<ModelProperty<? super BlockWithOnlyPortalTrustedBanners, ?>> needBsResyncProps() {
        return NEED_UPDATE_IN_BK_FIELDS;
    }
}
