package ru.yandex.partner.core.entity.block.type.page;

import java.util.Objects;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithContextPage;
import ru.yandex.partner.core.entity.dsp.model.Dsp;
import ru.yandex.partner.core.entity.dsp.rules.DspRule;
import ru.yandex.partner.core.entity.dsp.rules.DspRuleComponent;
import ru.yandex.partner.core.entity.dsp.rules.DspRuleContainer;
import ru.yandex.partner.core.entity.dsp.rules.DspRuleSet;
import ru.yandex.partner.core.entity.dsp.rules.result.DspRuleResult;
import ru.yandex.partner.core.entity.page.model.ExternalPageWithSite;

import static ru.yandex.partner.core.CoreConstants.DSP_AWAPS_ID;
import static ru.yandex.partner.dbschema.partner.Tables.DSP;
import static ru.yandex.partner.dbschema.partner.Tables.SITE;

@Component
public class BlockWithContextPageDspRules extends DspRuleComponent<BlockWithContextPage> {
    @Override
    public Class<BlockWithContextPage> getEntireTypeClass() {
        return null;
    }

    @Override
    public DspRuleSet getDspRuleSet(DspRuleContainer container) {
        return new DspRuleSet()
                .withRule(new DspRule<ExternalPageWithSite, BaseBlock, Dsp>() {
                    @Override
                    public DspRuleResult defaultDsps(DspRuleContainer dspRuleContainer, ExternalPageWithSite page,
                                                     BaseBlock block) {
                        if (Objects.equals(page.getIsGraysite(), Boolean.TRUE)) {
                            return DspRuleResult.limit(DSP.ID.notEqual(DSP_AWAPS_ID));
                        } else {
                            return DspRuleResult.limitIdentity();
                        }
                    }

                    @Override
                    public DspRuleResult turnOnDsps(DspRuleContainer dspRuleContainer, ExternalPageWithSite page,
                                                    BaseBlock block, Dsp dsp) {
                        if (dsp.getId().equals(DSP_AWAPS_ID)) {
                            return DspRuleResult.limit(SITE.IS_GRAYSITE.eq(0L));
                        } else {
                            return DspRuleResult.limitIdentity();
                        }
                    }
                });
    }
}
