package ru.yandex.partner.core.entity.block.type.page;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.QueryOpts;
import ru.yandex.partner.core.entity.block.model.BlockWithInternalContextPage;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupport;
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportWithoutMapper;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.core.entity.page.service.PageService;

import static ru.yandex.partner.core.utils.FunctionalUtils.mapList;

@Component
@ParametersAreNonnullByDefault
public class BlockWithInternalContextPageRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupport<BlockWithInternalContextPage>
        implements BlockRepositoryTypeSupportWithoutMapper<BlockWithInternalContextPage> {

    private final PageService pageService;
    private final Set<ModelProperty<? super BlockWithInternalContextPage, ?>> affectedModelProperties;
    private final Set<ModelProperty<? extends Model, ?>> pageModelProperties;

    @Autowired
    public BlockWithInternalContextPageRepositoryTypeSupport(DSLContext dslContext, PageService pageService) {
        super(dslContext);
        this.pageService = pageService;

        this.affectedModelProperties = Set.of(
                BlockWithInternalContextPage.ID,
                BlockWithInternalContextPage.CAMPAIGN
        );

        this.pageModelProperties = Set.of(
                InternalContextPage.ID,
                InternalContextPage.PAGE_ID,
                InternalContextPage.OWNER_ID,
                InternalContextPage.OWNER,
                InternalContextPage.DOMAIN_ID,
                InternalContextPage.DOMAIN,
                InternalContextPage.ALLOWED_TURBO,
                InternalContextPage.MULTISTATE,
                InternalContextPage.UNMODERATED_RTB_AUCTION,
                InternalContextPage.MANAGER_IDS,
                InternalContextPage.BLOCKS_COUNT,
                InternalContextPage.BLOCKS_LIMIT
        );
    }

    @Override
    public Set<ModelProperty<? super BlockWithInternalContextPage, ?>> getAffectedModelProperties() {
        return affectedModelProperties;
    }

    @Override
    public Class<BlockWithInternalContextPage> getTypeClass() {
        return BlockWithInternalContextPage.class;
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<BlockWithInternalContextPage> models) {
        Map<Long, InternalContextPage> internalContextPage = pageService.findAll(
                QueryOpts.forClass(InternalContextPage.class)
                        .withFilterByIds(mapList(models, BlockWithInternalContextPage::getPageId))
                        .withProps(pageModelProperties))
                .stream()
                .collect(Collectors.toMap(InternalContextPage::getId, Function.identity()));

        for (BlockWithInternalContextPage model : models) {
            model.setCampaign(internalContextPage.get(model.getPageId()));
        }
    }
}
