package ru.yandex.partner.core.entity.block.type.page;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.QueryOpts;
import ru.yandex.partner.core.entity.block.model.BlockWithInternalMobileApp;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupport;
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportWithoutMapper;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;
import ru.yandex.partner.core.entity.page.service.PageService;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.operator.FilterOperator;

import static ru.yandex.partner.core.utils.FunctionalUtils.mapList;

@Component
@ParametersAreNonnullByDefault
public class BlockWithInternalMobileAppRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupport<BlockWithInternalMobileApp>
        implements BlockRepositoryTypeSupportWithoutMapper<BlockWithInternalMobileApp> {


    private final Set<ModelProperty<? super BlockWithInternalMobileApp, ?>> affectedModelProperties;
    private final PageService pageService;
    private final Set<ModelProperty<? extends Model, ?>> pageModelProperties;

    public BlockWithInternalMobileAppRepositoryTypeSupport(DSLContext dslContext, PageService pageService) {
        super(dslContext);
        this.pageService = pageService;

        affectedModelProperties = Set.of(
                BlockWithInternalMobileApp.ID,
                BlockWithInternalMobileApp.CAMPAIGN
        );

        this.pageModelProperties = Set.of(
                InternalMobileApp.ID,
                InternalMobileApp.MULTISTATE,
                InternalMobileApp.BLOCKS_COUNT,
                InternalMobileApp.BLOCKS_LIMIT,
                InternalMobileApp.PAGE_ID,
                InternalMobileApp.UNMODERATED_RTB_AUCTION,
                InternalMobileApp.OWNER_ID,
                InternalMobileApp.OWNER,
                InternalMobileApp.APPLICATION_ID,
                InternalMobileApp.DOMAIN,
                InternalMobileApp.DOMAIN_ID,
                InternalMobileApp.TYPE,
                InternalMobileApp.STORE_ID,
                InternalMobileApp.MANAGER_IDS
        );
    }

    @Override
    public Set<ModelProperty<? super BlockWithInternalMobileApp, ?>> getAffectedModelProperties() {
        return affectedModelProperties;
    }

    @Override
    public Class<BlockWithInternalMobileApp> getTypeClass() {
        return BlockWithInternalMobileApp.class;
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<BlockWithInternalMobileApp> models) {
        Map<Long, InternalMobileApp> apps = pageService.findAll(
                        QueryOpts.forClass(InternalMobileApp.class)
                                .withFilter(CoreFilterNode.create(
                                        PageFilters.PAGE_ID,
                                        FilterOperator.IN,
                                        mapList(models, BlockWithInternalMobileApp::getPageId)
                                ))
                                .withProps(pageModelProperties))
                .stream()
                .collect(Collectors.toMap(InternalMobileApp::getId, Function.identity()));

        for (BlockWithInternalMobileApp model : models) {
            model.setCampaign(apps.get(model.getPageId()));
        }
    }
}
