package ru.yandex.partner.core.entity.block.type.page;

import java.util.Objects;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.dsp.model.Dsp;
import ru.yandex.partner.core.entity.dsp.rules.DspRule;
import ru.yandex.partner.core.entity.dsp.rules.DspRuleComponent;
import ru.yandex.partner.core.entity.dsp.rules.DspRuleContainer;
import ru.yandex.partner.core.entity.dsp.rules.DspRuleSet;
import ru.yandex.partner.core.entity.dsp.rules.result.DspRuleResult;
import ru.yandex.partner.core.entity.page.model.PageWithOwner;
import ru.yandex.partner.core.entity.user.model.User;

import static ru.yandex.partner.core.CoreConstants.ADINSIDE_CLIENT_ID;
import static ru.yandex.partner.core.CoreConstants.INTERNAL_DSP_TAGS;
import static ru.yandex.partner.dbschema.partner.Tables.DSP;
import static ru.yandex.partner.dbschema.partner.Tables.USERS;

@Component
public class BlockWithPageDspRules extends DspRuleComponent<BaseBlock> {
    @Override
    public Class<BaseBlock> getEntireTypeClass() {
        return null;
    }

    @Override
    public DspRuleSet getDspRuleSet(DspRuleContainer container) {
        return new DspRuleSet()
                .withRule(
                        new DspRule<PageWithOwner, BaseBlock, Dsp>() {
                            @Override
                            public DspRuleResult defaultDsps(
                                    DspRuleContainer dspRuleContainer, PageWithOwner page, BaseBlock block) {
                                User owner = page.getOwner();
                                if (owner != null) {
                                    if (Objects.equals(owner.getClientId(), ADINSIDE_CLIENT_ID) ||
                                            Objects.equals(owner.getBusinessUnit(), Boolean.TRUE)) {
                                        return DspRuleResult.limit(DSP.TAG.in(INTERNAL_DSP_TAGS));
                                    }
                                }
                                return DspRuleResult.limitIdentity();
                            }

                            @Override
                            public DspRuleResult turnOnDsps(
                                    DspRuleContainer dspRuleContainer, PageWithOwner page, BaseBlock block, Dsp dsp) {
                                if (INTERNAL_DSP_TAGS.contains(dsp.getTag())) {
                                    return DspRuleResult.limitIdentity();
                                }
                                return DspRuleResult.limit(
                                        USERS.CLIENT_ID.ne(ADINSIDE_CLIENT_ID)
                                                .and(USERS.BUSINESS_UNIT.eq(0L)
                                                ));
                            }
                        }
                );
    }
}
