package ru.yandex.partner.core.entity.block.type.pcode;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithPCodeAndDependsFields;
import ru.yandex.partner.core.entity.block.service.type.add.AbstractBlockAddOperationTypeSupport;
import ru.yandex.partner.core.service.msf.MsfUtils;

@Component
@ParametersAreNonnullByDefault
public class BlockWithPCodeAndDependsFieldsAddOperationTypeSupport
        extends AbstractBlockAddOperationTypeSupport<BlockWithPCodeAndDependsFields> {
    private final PCodeSettingsService pCodeSettingsService;

    @Autowired
    public BlockWithPCodeAndDependsFieldsAddOperationTypeSupport(PCodeSettingsService pCodeSettingsService) {
        this.pCodeSettingsService = pCodeSettingsService;
    }

    @Override
    public void onPreValidated(BlockContainer addContainer, List<BlockWithPCodeAndDependsFields> models) {
        for (BlockWithPCodeAndDependsFields model : models) {
            model.setPCodeSettings(
                    pCodeSettingsService.completeSettings(
                            model.getPCodeSettings(),
                            model.getSiteVersion(),
                            MsfUtils.getMsfRole(addContainer, model.getClass()),
                            model.getAdfoxBlock())
            );
        }
    }

    @Override
    public Class<BlockWithPCodeAndDependsFields> getTypeClass() {
        return BlockWithPCodeAndDependsFields.class;
    }
}
