package ru.yandex.partner.core.entity.block.type.pcode;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import NPartner.Page;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithPCode;
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.multitype.repository.EmptyTypeSupportModifyStrategy;
import ru.yandex.partner.core.utils.CommonConverters;

import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.convertibleJsonProperty;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
@ParametersAreNonnullByDefault
public class BlockWithPCodeRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithPCode>
        implements BlockBkFiller<BlockWithPCode> {
    private final JooqMapper<BlockWithPCode> mapper;
    private final ObjectMapper objectMapper;
    private final Set<ModelProperty<? super BlockWithPCode, ?>> affectedModelProperties;

    @Autowired
    public BlockWithPCodeRepositoryTypeSupport(DSLContext dslContext, ObjectMapper objectMapper) {
        super(dslContext, new EmptyTypeSupportModifyStrategy<>());
        this.objectMapper = objectMapper;
        this.affectedModelProperties = Set.of(BlockWithPCode.P_CODE_SETTINGS);

        this.mapper = JooqMapperBuilder.<BlockWithPCode>builder()
                .map(convertibleJsonProperty(
                        BlockWithPCode.P_CODE_SETTINGS, CONTEXT_ON_SITE_RTB.OPTS, "pcode_settings",
                        value -> CommonConverters.jsonNodeToMap(objectMapper, value),
                        value -> CommonConverters.mapToJsonNode(objectMapper, value)))
                .build();
    }

    @Override
    public void fillBkData(@NotNull BlockWithPCode model, @NotNull Page.TPartnerPage.TBlock.Builder bkData,
                           BlockBkDictContainer container) {
        if (model.getPCodeSettings() != null && !model.getPCodeSettings().isEmpty()) {
            try {
                bkData.setPCodeSettings(objectMapper.writeValueAsString(model.getPCodeSettings()));
            } catch (JsonProcessingException e) {
                throw new RuntimeException("Error during serialization to json. Value: " + model.getPCodeSettings(), e);
            }
        }
    }

    @Override
    public JooqMapper<BlockWithPCode> getJooqMapper() {
        return mapper;
    }

    @Override
    public Set<ModelProperty<? super BlockWithPCode, ?>> getAffectedModelProperties() {
        return affectedModelProperties;
    }

    @Override
    public Class<BlockWithPCode> getTypeClass() {
        return BlockWithPCode.class;
    }
}
