package ru.yandex.partner.core.entity.block.type.pcode;

import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithPCode;
import ru.yandex.partner.core.entity.block.model.BlockWithPCodeAndDependsFields;
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportFacade;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;
import ru.yandex.partner.core.service.msf.MsfUtils;

@Component
@ParametersAreNonnullByDefault
public class BlockWithPCodeUpdateOperationTypeSupport
        extends AbstractBlockUpdateOperationTypeSupport<BlockWithPCodeAndDependsFields> {

    private static final Set<ModelProperty<? super BlockWithPCodeAndDependsFields, ?>> NEED_BS_RESYNC_PROPERTIES =
            Set.of(BlockWithPCode.P_CODE_SETTINGS);

    private final PCodeSettingsService pCodeSettingsService;

    @Autowired
    public BlockWithPCodeUpdateOperationTypeSupport(BlockRepositoryTypeSupportFacade blockRepositoryTypeSupportFacade,
                                                    PCodeSettingsService pCodeSettingsService) {
        super(blockRepositoryTypeSupportFacade);
        this.pCodeSettingsService = pCodeSettingsService;
    }

    @Override
    public Set<ModelProperty<? super BlockWithPCodeAndDependsFields, ?>> needBsResyncProps() {
        return NEED_BS_RESYNC_PROPERTIES;
    }


    @Override
    public void onChangesApplied(BlockContainer updateContainer,
                                 List<AppliedChanges<BlockWithPCodeAndDependsFields>> appliedChanges) {

        appliedChanges.stream()
                .filter(appliedChange -> appliedChange.changed(BlockWithPCode.P_CODE_SETTINGS))
                .forEach(appliedChange -> {
                    Map<String, Object> newValue = pCodeSettingsService.completeSettings(
                            appliedChange.getNewValue(BlockWithPCodeAndDependsFields.P_CODE_SETTINGS),
                            appliedChange.getNewValue(BlockWithPCodeAndDependsFields.SITE_VERSION),
                            MsfUtils.getMsfRole(updateContainer, appliedChange.getModel().getClass()),
                            appliedChange.getNewValue(BlockWithPCodeAndDependsFields.ADFOX_BLOCK)
                    );
                    appliedChange.modify(BlockWithPCode.P_CODE_SETTINGS, newValue);
                });
    }

    @Override
    public Class<BlockWithPCodeAndDependsFields> getTypeClass() {
        return BlockWithPCodeAndDependsFields.class;
    }
}
