package ru.yandex.partner.core.entity.block.type.pcode;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithPCodeAndDependsFields;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;
import ru.yandex.partner.core.service.msf.FormatSystemService;

@Component
public class BlockWithPCodeValidationTypeSupport
        extends AbstractBlockValidationTypeSupport<BlockWithPCodeAndDependsFields> {

    private final FormatSystemService formatSystemService;

    @Autowired
    public BlockWithPCodeValidationTypeSupport(FormatSystemService formatSystemService) {
        this.formatSystemService = formatSystemService;
    }

    @Override
    public ValidationResult<List<BlockWithPCodeAndDependsFields>, Defect> validate(
            BlockContainer container, ValidationResult<List<BlockWithPCodeAndDependsFields>, Defect> vr) {

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator(container))
                .getResult();
    }

    @Override
    public Class<BlockWithPCodeAndDependsFields> getTypeClass() {
        return BlockWithPCodeAndDependsFields.class;
    }

    private Validator<BlockWithPCodeAndDependsFields, Defect> validator(BlockContainer container) {
        return block -> {
            var vb = ModelItemValidationBuilder.of(block);
            var pCodeSettingsValidator = new PCodeSettingsValidator(formatSystemService, block.getSiteVersion(),
                    container.getMode(),
                    container.getCanValidateDesignAsManager(block.getClass()), block.getAdfoxBlock());
            vb.item(BlockWithPCodeAndDependsFields.P_CODE_SETTINGS).checkBy(pCodeSettingsValidator,
                    When.valueIs(stringObjectMap -> stringObjectMap != null && !stringObjectMap.isEmpty()));

            return vb.getResult();
        };
    }
}
