package ru.yandex.partner.core.entity.block.type.pcode;

import java.util.Map;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.core.entity.block.service.OperationMode;
import ru.yandex.partner.core.service.msf.FormatSystemService;
import ru.yandex.partner.core.service.msf.MsfUtils;
import ru.yandex.partner.core.service.msf.dto.MsfValidationResultDto;

import static ru.yandex.partner.core.entity.block.service.validation.defects.BlockDefects.msfDefect;


@ParametersAreNonnullByDefault
public class PCodeSettingsValidator implements Validator<Map<String, Object>, Defect> {
    private final FormatSystemService formatSystemService;
    private final String siteVersion;
    private final String role;
    private final Boolean isAdfox;

    public PCodeSettingsValidator(FormatSystemService formatSystemService,
                                  String siteVersion,
                                  OperationMode mode,
                                  boolean canValidateAsManager,
                                  Boolean isAdfox) {
        this.formatSystemService = formatSystemService;
        this.siteVersion = siteVersion;
        this.role = MsfUtils.getMsfRole(canValidateAsManager, mode);
        this.isAdfox = isAdfox;
    }

    @Override
    public ValidationResult<Map<String, Object>, Defect> apply(Map<String, Object> pCodeSettings) {
        var validationBuilder = ItemValidationBuilder.of(pCodeSettings, Defect.class);

        var msfResult = formatSystemService.validatePCodeSettings(CoreConstants.Msf.RU_LANG, role,
                siteVersion, isAdfox, pCodeSettings);

        processMsfResult(pCodeSettings, validationBuilder, msfResult);

        return validationBuilder.getResult();
    }

    private void processMsfResult(Map<String, Object> pCodeSettings,
                                  ItemValidationBuilder<Map<String, Object>, Defect> validationBuilder,
                                  @Nullable MsfValidationResultDto msfResult) {
        if (msfResult == null || msfResult.isValid()) {
            return;
        }
        msfResult.getMessages().forEach(it -> validationBuilder.checkByFunction(x -> msfDefect(it.getText())));
        for (var item : msfResult.getItems().entrySet()) {
            item.getValue().getMessages().forEach(it ->
                    validationBuilder.item(pCodeSettings.get(item.getKey()), item.getKey())
                            .checkByFunction(x -> msfDefect(item.getKey(), it.getText()), When.isValid())
            );
        }
    }

}
