package ru.yandex.partner.core.entity.block.type.picategories;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithPiCategories;
import ru.yandex.partner.core.entity.block.service.type.add.AbstractBlockAddOperationTypeSupport;
import ru.yandex.partner.core.entity.common.utils.ModelWithBlockPageIdsUtils;

@Component
public class BlockWithPiCategoriesAddOperationTypeSupport
        extends AbstractBlockAddOperationTypeSupport<BlockWithPiCategories> {
    @Override
    public Class<BlockWithPiCategories> getTypeClass() {
        return BlockWithPiCategories.class;
    }

    @Override
    public void onDuplicate(BlockContainer addModelContainer, List<BlockWithPiCategories> models) {
        models.forEach(it -> ModelWithBlockPageIdsUtils.clearPageBlockIds(it.getPiCategories()));
    }

    @Override
    public void beforeExecution(BlockContainer addContainer, List<BlockWithPiCategories> models) {
        models.forEach(it -> ModelWithBlockPageIdsUtils.setPageBlockIds(it.getPiCategories(),
                it, addContainer.getMode()));
    }
}
