package ru.yandex.partner.core.entity.block.type.picategories;

import java.util.List;
import java.util.Set;
import java.util.function.Function;

import javax.annotation.Nonnull;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithPiCategories;
import ru.yandex.partner.core.entity.block.model.PiCategory;
import ru.yandex.partner.core.entity.block.model.prop.BlockWithPiCategoriesPiCategoriesPropHolder;
import ru.yandex.partner.core.validation.ModelWithDictEntriesListValidator;

public class BlockWithPiCategoriesListValidator extends ModelWithDictEntriesListValidator<BlockWithPiCategories,
        PiCategory> {

    private final PiCategoriesValidatorProvider piCategoriesValidatorProvider;

    public BlockWithPiCategoriesListValidator(PiCategoriesValidatorProvider piCategoriesValidatorProvider,
                                              Set<Long> existingPiCategoriesIds) {
        super(existingPiCategoriesIds);
        this.piCategoriesValidatorProvider = piCategoriesValidatorProvider;
    }

    @Override
    protected void validateModel(ModelItemValidationBuilder<BlockWithPiCategories> vb) {
        vb.list(getModelPropertyToCheck()).checkEachBy(piCategoriesValidatorProvider.piCategoriesValidator());
    }

    @Override
    protected ModelProperty<BlockWithPiCategoriesPiCategoriesPropHolder, List<PiCategory>> getModelPropertyToCheck() {
        return BlockWithPiCategories.PI_CATEGORIES;
    }

    @Override
    @Nonnull
    protected Function<PiCategory, Long> idGetter() {
        return PiCategory::getId;
    }
}
