package ru.yandex.partner.core.entity.block.type.picategories;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import one.util.streamex.StreamEx;
import org.apache.commons.lang3.tuple.Pair;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithPiCategories;
import ru.yandex.partner.core.entity.block.model.PiCategory;
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportFacade;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;
import ru.yandex.partner.core.entity.common.utils.ModelWithBlockPageIdsUtils;
import ru.yandex.partner.core.entity.picategories.PiCategoriesRepository;
import ru.yandex.partner.core.entity.picategories.filter.PiCategoryFilters;
import ru.yandex.partner.core.multitype.repository.relation.CollectionRelation;
import ru.yandex.partner.core.multitype.repository.relation.Relation;
import ru.yandex.partner.core.multitype.repository.relation.RelationRepository;
import ru.yandex.partner.core.multitype.repository.relation.UpdateStrategy;

@Component
public class BlockWithPiCategoriesUpdateOperationTypeSupport
        extends AbstractBlockUpdateOperationTypeSupport<BlockWithPiCategories> {

    private static final Set<ModelProperty<? super BlockWithPiCategories, ?>> NEED_UPDATE_IN_BK_FIELDS =
            Set.of(BlockWithPiCategories.PI_CATEGORIES);

    private final Relation<BlockWithPiCategories, PiCategory, List<PiCategory>> piCategoryModelRelation;

    @Autowired
    public BlockWithPiCategoriesUpdateOperationTypeSupport(
            PiCategoriesRepository piCategoriesRepository,
            BlockRepositoryTypeSupportFacade blockRepositoryTypeSupportFacade) {
        super(blockRepositoryTypeSupportFacade);
        this.piCategoryModelRelation = new CollectionRelation<>(BlockWithPiCategories.PI_CATEGORIES,
                RelationRepository.of(piCategoriesRepository, PiCategoryFilters.pageId(), PiCategoryFilters.blockId()),
                UpdateStrategy.rewrite(),
                PiCategory::getId);
    }

    @Override
    public Class<BlockWithPiCategories> getTypeClass() {
        return BlockWithPiCategories.class;
    }

    @Override
    public void updateRelatedEntitiesInTransaction(
            DSLContext dslContext,
            BlockContainer updateContainer,
            List<AppliedChanges<BlockWithPiCategories>> appliedChanges) {

        StreamEx.of(appliedChanges)
                .forEach(it -> {
                            var block = it.getModel();
                            ModelWithBlockPageIdsUtils.setPageBlockIds(block.getPiCategories(),
                                    block, updateContainer.getMode());
                        }
                );
        piCategoryModelRelation.processUpdate(
                appliedChanges.stream()
                        .filter(changes -> changes.changed(piCategoryModelRelation.getProperty()))
                        .map(changes -> Pair.of(
                                changes.getOldValue(piCategoryModelRelation.getProperty()),
                                changes.getNewValue(piCategoryModelRelation.getProperty())
                        )).collect(Collectors.toList()),
                updateContainer.getIncomingFields()
        );
    }

    @Override
    public Set<ModelProperty<? super BlockWithPiCategories, ?>> needBsResyncProps() {
        return NEED_UPDATE_IN_BK_FIELDS;
    }
}
