package ru.yandex.partner.core.entity.block.type.picategories;

import java.util.List;
import java.util.stream.Collectors;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithPiCategories;
import ru.yandex.partner.core.entity.block.model.PiCategory;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;
import ru.yandex.partner.core.entity.picategories.PiCategoriesDictRepository;

@Component
public class BlockWithPiCategoriesValidationTypeSupport
        extends AbstractBlockValidationTypeSupport<BlockWithPiCategories> {

    private final BlockWithPiCategoriesValidatorProvider validatorProvider;

    private final DSLContext dslContext;
    private final PiCategoriesDictRepository piCategoriesDictRepository;

    @Autowired
    public BlockWithPiCategoriesValidationTypeSupport(BlockWithPiCategoriesValidatorProvider validatorProvider,
                                                      DSLContext dslContext,
                                                      PiCategoriesDictRepository piCategoriesDictRepository) {

        this.validatorProvider = validatorProvider;
        this.dslContext = dslContext;
        this.piCategoriesDictRepository = piCategoriesDictRepository;
    }

    @Override
    public void fillContainer(BlockContainer container, List<BlockWithPiCategories> blocks) {
        if (container.getAvailablePiCategoriesIds() == null) {
            container.setAvailablePiCategoriesIds(piCategoriesDictRepository.getExistingIds(
                    dslContext,
                    blocks.stream().filter(b -> b.getPiCategories() != null)
                            .flatMap(block -> block.getPiCategories().stream().map(PiCategory::getId))
                            .collect(Collectors.toSet())
                    )
            );
        }
    }

    @Override
    public void fillContainerFullDictionaries(BlockContainer container) {
        container.setAvailablePiCategoriesIds(piCategoriesDictRepository.getAllExistingIds(dslContext));
    }

    @Override
    public ValidationResult<List<BlockWithPiCategories>, Defect>
    addPreValidate(BlockContainer container,
                   ValidationResult<List<BlockWithPiCategories>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.addPreValidator(), When.isTrue(container.getMode().creation()))
                .getResult();
    }

    @Override
    public Class<BlockWithPiCategories> getTypeClass() {
        return BlockWithPiCategories.class;
    }

    @Override
    public ValidationResult<List<BlockWithPiCategories>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<BlockWithPiCategories>, Defect> vr) {

        return new ListValidationBuilder<>(vr)
                .checkBy(validatorProvider.validator(container.getAvailablePiCategoriesIds()))
                .getResult();
    }
}
