package ru.yandex.partner.core.entity.block.type.picategories;

import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithPiCategories;
import ru.yandex.partner.core.entity.block.model.PiCategory;
import ru.yandex.partner.core.entity.common.validation.ModelWithBlockPageIdValidatorProvider;

import static ru.yandex.partner.core.entity.block.model.prop.BlockWithPiCategoriesPiCategoriesPropHolder.PI_CATEGORIES;

@Component
public class BlockWithPiCategoriesValidatorProvider {

    private final PiCategoriesValidatorProvider piCategoriesValidatorProvider;
    private final ModelWithBlockPageIdValidatorProvider<PiCategory> modelWithBlockPageIdValidatorProvider;

    @Autowired
    public BlockWithPiCategoriesValidatorProvider(PiCategoriesValidatorProvider piCategoriesValidatorProvider,
                                                  ModelWithBlockPageIdValidatorProvider<PiCategory>
                                                          modelWithBlockPageIdValidatorProvider) {
        this.piCategoriesValidatorProvider = piCategoriesValidatorProvider;
        this.modelWithBlockPageIdValidatorProvider = modelWithBlockPageIdValidatorProvider;
    }

    public Validator<List<BlockWithPiCategories>, Defect> validator(Set<Long> existingPiCategoriesIds) {
        return new BlockWithPiCategoriesListValidator(piCategoriesValidatorProvider, existingPiCategoriesIds);
    }

    public Validator<BlockWithPiCategories, Defect> addPreValidator() {
        return block -> {
            var vb = ModelItemValidationBuilder.of(block);
            vb.list(PI_CATEGORIES)
                    .checkEachBy(modelWithBlockPageIdValidatorProvider.addPreValidator());
            return vb.getResult();
        };
    }
}
