package ru.yandex.partner.core.entity.block.type.picategories

import org.jooq.DSLContext
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service
import ru.yandex.partner.core.entity.block.type.custombkdata.BkDataException
import ru.yandex.partner.core.entity.utils.CpmUtils
import ru.yandex.partner.dbschema.partner.tables.PicategoriesDict

@Service
class PiCategoriesDictService @Autowired constructor(
    private val dslContext: DSLContext
) {

    fun getCategoryDict(): Map<Long, CpmUtils.CpmNode> {
        val dict = dslContext.select(
            PicategoriesDict.PICATEGORIES_DICT.CATEGORY_ID,
            PicategoriesDict.PICATEGORIES_DICT.PARENT_ID,
            PicategoriesDict.PICATEGORIES_DICT.NAME_RU,
            PicategoriesDict.PICATEGORIES_DICT.LEVEL)
            .from(PicategoriesDict.PICATEGORIES_DICT)
            .orderBy(
                PicategoriesDict.PICATEGORIES_DICT.LEVEL,
                PicategoriesDict.PICATEGORIES_DICT.NAME_RU)
            .fetchMap({ record ->
                record.get(PicategoriesDict.PICATEGORIES_DICT.CATEGORY_ID)
            },
                { record ->
                    CpmUtils.CpmNode(
                        id = record.get(PicategoriesDict.PICATEGORIES_DICT.CATEGORY_ID),
                        parentId = record.get(PicategoriesDict.PICATEGORIES_DICT.PARENT_ID),
                        name = record.get(PicategoriesDict.PICATEGORIES_DICT.NAME_RU),
                        level = record.get(PicategoriesDict.PICATEGORIES_DICT.LEVEL)
                    )
                }
            )

        if (!dict.containsKey(0L)) {
            throw BkDataException("First element should be on level 0")
        }

        dict.values.forEach {
            if (!dict.containsKey(it.parentId)) {
                throw BkDataException("No parent ${it.parentId} for entry ${it.id}")
            }
        }
        return dict
    }

}
