package ru.yandex.partner.core.entity.block.type.picategories;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.core.entity.block.model.PiCategory;
import ru.yandex.partner.core.entity.block.service.validation.defects.BlockDefectIds;
import ru.yandex.partner.core.entity.block.service.validation.defects.StrategyDefectParams;
import ru.yandex.partner.core.validation.constraints.PartnerNumberConstraints;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.NumberConstraints.greaterThan;
import static ru.yandex.direct.validation.constraint.NumberConstraints.inRange;
import static ru.yandex.partner.core.CoreConstants.MAX_CPM;
import static ru.yandex.partner.core.CoreConstants.MIN_CPM;

public class PiCategoriesValidator implements Validator<PiCategory, Defect> {

    @Override
    public ValidationResult<PiCategory, Defect> apply(PiCategory piCategory) {
        ModelItemValidationBuilder<PiCategory> vb = ModelItemValidationBuilder.of(piCategory);
        vb.item(PiCategory.ID).check(notNull()).check(greaterThan(0L), When.notNull());
        var defect = new Defect<>(BlockDefectIds.Strategy.INCORRECT_MINCPM_VALUE,
                new StrategyDefectParams().withMinCpm(MIN_CPM).withMaxCpm(MAX_CPM));
        vb.item(PiCategory.CPM).check(notNull()).check(inRange(MIN_CPM, CoreConstants.MAX_CPM), defect, When.notNull())
                .check(PartnerNumberConstraints.maxScale(CoreConstants.CPM_MAX_SCALE), defect);
        return vb.getResult();
    }
}
