package ru.yandex.partner.core.entity.block.type.placeid

import org.springframework.stereotype.Component
import ru.yandex.partner.core.entity.block.container.BlockContainer
import ru.yandex.partner.core.entity.block.model.BlockWithPlaceId
import ru.yandex.partner.core.entity.block.service.type.add.AbstractBlockAddOperationTypeSupport
import java.util.function.Consumer

@Component
class BlockWithPlaceIdAddOperationTypeSupport  : AbstractBlockAddOperationTypeSupport<BlockWithPlaceId>() {
    override fun onDuplicate(addModelContainer: BlockContainer?, models: List<BlockWithPlaceId>) {
        models.forEach(Consumer { model: BlockWithPlaceId ->
            model.placeId = null
        })
    }
    override fun getTypeClass() = BlockWithPlaceId::class.java
}
