package ru.yandex.partner.core.entity.block.type.placeid;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithPlaceId;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
public class BlockWithPlaceIdRepositoryTypeSupport extends
        AbstractBlockRepositoryTypeSupportWithMapper<BlockWithPlaceId> implements
        CoreModelProvider<BlockWithPlaceId> {

    public static final CoreModel<BlockWithPlaceId> MODEL =
            CoreModel.forClass(BlockWithPlaceId.class)
                    .property(
                            ModelPropertyDefault.<BlockWithPlaceId, Long>forProperty(BlockWithPlaceId.PLACE_ID)
                                    .optional()
                    )
                    .build();

    private final JooqMapper<BlockWithPlaceId> mapper;

    public BlockWithPlaceIdRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
        this.mapper = JooqMapperBuilder.<BlockWithPlaceId>builder()
                .map(property(BlockWithPlaceId.PLACE_ID, CONTEXT_ON_SITE_RTB.PLACE_ID))
                .build();
    }

    @Override
    public JooqMapper<BlockWithPlaceId> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<BlockWithPlaceId> getTypeClass() {
        return BlockWithPlaceId.class;
    }

    @Override
    public CoreModel<BlockWithPlaceId> getCoreModel() {
        return MODEL;
    }
}
