package ru.yandex.partner.core.entity.block.type.placeid;

import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.block.BlockType;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithPlaceId;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;

@Component
public class BlockWithPlaceIdUpdateOperationTypeSupport
        extends AbstractBlockUpdateOperationTypeSupport<BlockWithPlaceId> {

    private static final Set<ModelProperty<? super BlockWithPlaceId, ?>> NEED_BS_RESYNC_PROPS =
            Set.of(BlockWithPlaceId.PLACE_ID);

    public BlockWithPlaceIdUpdateOperationTypeSupport(PartnerRepositoryTypeSupportFacade<BaseBlock, BlockType,
            BlockContainer, BlockContainer> repositoryFacade) {
        super(repositoryFacade);
    }

    @Override
    public Class<BlockWithPlaceId> getTypeClass() {
        return BlockWithPlaceId.class;
    }

    @Override
    public Set<ModelProperty<? super BlockWithPlaceId, ?>> needBsResyncProps() {
        return NEED_BS_RESYNC_PROPS;
    }
}
