package ru.yandex.partner.core.entity.block.type.readonly;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithReadonly;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.multitype.repository.EmptyTypeSupportModifyStrategy;

import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonBooleanToLong;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
@ParametersAreNonnullByDefault
public class BlockWithReadonlyRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithReadonly> {
    private final JooqMapper<BlockWithReadonly> mapper;

    @Autowired
    protected BlockWithReadonlyRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext, new EmptyTypeSupportModifyStrategy<>());
        this.mapper = JooqMapperBuilder.<BlockWithReadonly>builder()
                .map(jsonBooleanToLong(BlockWithReadonly.READONLY, CONTEXT_ON_SITE_RTB.OPTS, "readonly"))
                .build();
    }

    @Override
    public JooqMapper<BlockWithReadonly> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<BlockWithReadonly> getTypeClass() {
        return BlockWithReadonly.class;
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<BlockWithReadonly> blocks) {
    }
}
