package ru.yandex.partner.core.entity.block.type.richmedia;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders;
import ru.yandex.partner.core.entity.block.model.BlockWithRichMedia;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.multitype.repository.EmptyTypeSupportModifyStrategy;
import ru.yandex.partner.dbschema.partner.tables.ContextOnSiteRtb;

@Component
@ParametersAreNonnullByDefault
public class BlockWithRichMediaRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithRichMedia> {
    private final JooqMapper<BlockWithRichMedia> mapper;

    @Autowired
    protected BlockWithRichMediaRepositoryTypeSupport(
            DSLContext dslContext
    ) {
        super(dslContext, new EmptyTypeSupportModifyStrategy<>());
        this.mapper = JooqMapperBuilder.<BlockWithRichMedia>builder()
                .map(
                        JsonReaderWriterBuilders.jsonBoolean(
                                BlockWithRichMedia.RICH_MEDIA,
                                ContextOnSiteRtb.CONTEXT_ON_SITE_RTB.OPTS,
                                "rich_media"
                        )
                )
                .build();
    }
    @Override
    public JooqMapper<BlockWithRichMedia> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<BlockWithRichMedia> getTypeClass() {
        return BlockWithRichMedia.class;
    }
}

