package ru.yandex.partner.core.entity.block.type.rtb

import NPartner.Page.TPartnerPage.TBlock
import org.springframework.stereotype.Component
import ru.yandex.partner.core.block.MobileBlockType
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer
import ru.yandex.partner.core.entity.block.model.BlockWithBlockTypeAndRichMediaAndShowVideo
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller
import ru.yandex.partner.libs.bs.ext.adTypeSet

@Component
class BlockWithBlockTypeRichMediaAndShowVideoBkFiller :
    BlockBkFiller<BlockWithBlockTypeAndRichMediaAndShowVideo> {
    override fun fillBkData(
        block: BlockWithBlockTypeAndRichMediaAndShowVideo,
        bkData: TBlock.Builder,
        container: BlockBkDictContainer
    ) {
        when (block.blockType) {
            MobileBlockType.INTERSTITIAL.literal -> {
                bkData.adTypeSet(TBlock.EAdType.MEDIA).setValue(true)
                bkData.adTypeSet(TBlock.EAdType.MEDIA_PERFORMANCE).setValue(true)
                bkData.adTypeSet(TBlock.EAdType.TEXT).setValue(true)
                bkData.adTypeSet(TBlock.EAdType.VIDEO).setValue(true)
                bkData.adTypeSet(TBlock.EAdType.VIDEO_MOTION).setValue(true)
                bkData.adTypeSet(TBlock.EAdType.VIDEO_PERFORMANCE).setValue(true)
            }
            MobileBlockType.REWARDED.literal -> {
                bkData.adTypeSet(TBlock.EAdType.MEDIA).setValue(false)
                bkData.adTypeSet(TBlock.EAdType.MEDIA_PERFORMANCE).setValue(false)
                bkData.adTypeSet(TBlock.EAdType.TEXT).setValue(false)
                bkData.adTypeSet(TBlock.EAdType.VIDEO).setValue(true)
                bkData.adTypeSet(TBlock.EAdType.VIDEO_MOTION).setValue(true)
                bkData.adTypeSet(TBlock.EAdType.VIDEO_PERFORMANCE).setValue(true)
            }
            MobileBlockType.NATIVE.literal -> {
                val mediaAdTypesEnabled = block.richMedia == true
                val videoAdTypesEnabled = block.showVideo == true

                // TODO(satsakul): PI-29304. Implicit disabling of video-motion and video-performance ad types. Potential bug.
                bkData.adTypeSet(TBlock.EAdType.TEXT).setValue(true)
                bkData.adTypeSet(TBlock.EAdType.MEDIA).setValue(mediaAdTypesEnabled)
                bkData.adTypeSet(TBlock.EAdType.MEDIA_PERFORMANCE).setValue(mediaAdTypesEnabled)
                bkData.adTypeSet(TBlock.EAdType.VIDEO).setValue(videoAdTypesEnabled)
            }
            MobileBlockType.BANNER.literal -> {
                val videoAdTypesEnabled = block.showVideo == true

                // TODO(satsakul): PI-29304. Implicit disabling of video-motion and video-performance ad types. Potential bug.
                bkData.adTypeSet(TBlock.EAdType.MEDIA).setValue(true)
                bkData.adTypeSet(TBlock.EAdType.MEDIA_PERFORMANCE).setValue(true)
                bkData.adTypeSet(TBlock.EAdType.TEXT).setValue(true)
                bkData.adTypeSet(TBlock.EAdType.VIDEO).setValue(videoAdTypesEnabled)
            }
            else -> {
                throw IllegalArgumentException("Unexpected blockType: ${block.blockType}")
            }
        }
    }

    override fun getTypeClass(): Class<BlockWithBlockTypeAndRichMediaAndShowVideo> {
        return BlockWithBlockTypeAndRichMediaAndShowVideo::class.java
    }
}
