package ru.yandex.partner.core.entity.block.type.rtb

import NPartner.Page.TPartnerPage
import org.springframework.stereotype.Component
import ru.yandex.partner.core.CoreConstants
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer
import ru.yandex.partner.core.entity.block.model.BlockWithRtbFieldsAndDesignTemplates
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller
import ru.yandex.partner.core.entity.utils.DesignSettingIntParser
import ru.yandex.partner.dbschema.partner.enums.DesignTemplatesType

@Component
class BlockWithRtbFieldAndDesignTemplatesBkFiller : BlockBkFiller<BlockWithRtbFieldsAndDesignTemplates> {
    override fun fillBkData(
        block: BlockWithRtbFieldsAndDesignTemplates,
        bkData: TPartnerPage.TBlock.Builder,
        container: BlockBkDictContainer
    ) {
        if (bkData.hasDirectLimit()) {
            return
        }
        if (block.blockId == CoreConstants.TECHNICAL_RTB_BLOCK_ID) {
            bkData.directLimit = 9
        } else if (block.designTemplates == null) {
            bkData.directLimit = 0
        } else {
            block.designTemplates.filter { it.type in setOf(DesignTemplatesType.tga, DesignTemplatesType.native_) }
                .maxOfOrNull {
                    if (it.type == DesignTemplatesType.native_) {
                        (DesignSettingIntParser.parseInt(
                            it.designSettings.getOrDefault("grid_columns", 0)
                        ) ?: 0) *
                            (DesignSettingIntParser.parseInt(
                                it.designSettings.getOrDefault("grid_rows", 0)
                            ) ?: 0)
                    } else {
                        DesignSettingIntParser.parseInt(
                            it.designSettings.getOrDefault("limit", 0)
                        ) ?: 0
                    }
                }?.let {
                    bkData.directLimit = it
                }
        }
    }

    override fun order(): Int {
        return BlockBkFiller.Order.RTB_FIELDS_AND_DESIGN_TEMPLATES.ordinal
    }

    override fun getTypeClass(): Class<BlockWithRtbFieldsAndDesignTemplates> {
        return BlockWithRtbFieldsAndDesignTemplates::class.java
    }
}
